--Order of Battle - Aircraft/Helicopter
--organized in units (squadrons/regiments) containing a number of aircraft

--[[ Unit Entry Example ----------------------------------------------------------------------------

[1] = {
	inactive = true,								--true if unit is not active
	player = true,									--true for player unit
	name = "527 TFS",								--unit name
	type = "F-5E-3",								--aircraft type
	helicopter = true,								--true for helicopter units
	country = "USA",								--unit country
	livery = {"USAF Euro Camo"},					--unit livery
	base = "Groom Lake AFB",						--unit base
	skill = "Random",								--unit skill
	tasks = {										--list of eligible unit tasks. Note: task names do not necessary match DCS tasks)
		["AWACS"] = true,							
		["Anti-ship Strike"] = true,
		["CAP"] = true,
		["Fighter Sweep"] = true,	
		["Intercept"] = true,
		["Reconnaissance"] = true,
		["Refueling"] = true,
		["Strike"] = true,							--Generic air-ground task (replaces "Ground Attack", "CAS" and "Pinpoint Strike")
		["Transport"] = true,
		["Escort"] = true,							--Support task: Fighter escort for package
		["SEAD"] = true,							--Support task: SEAD escort for package
		["Escort Jammer"] = true,					--Support task: Single airraft in center of package for defensive jamming
		["Flare Illumination"] = true,				--Support task: Illuminate target with flares for package
		["Laser Illumination"] = true,				--Support task: Lase target for package
		["Stand-Off Jammer"] = true,				--Not implemeted yet: On-station jamming
		["Chaff Escort"] = true,					--Not implemented yet: Lay chaff corrdior ahead of package
		["A-FAC"] = true,							--Not implemented yet: Airborne forward air controller
	},
	number = 12,									--number of airframes
},

]]-----------------------------------------------------------------------------------------------------

oob_air = {
	["blue"] = {											--side 1
		[1] = {
			name = "No. 5 Squadron",								--unit name
			player = false,									--player unit
			type = "F-16C_50",								--aircraft type
			country = "Pakistan",								--unit country
			livery = {""},					--unit livery
			base = "Nellis AFB",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,
				["Escort"] = true,
				["CAP"] = true,
				["Intercept"] = true,
			},
			number = 10,
		},
		[2] = {
			name = "R-No.5",								--unit name
			inactive = true,								--unit is inactive
			type = "F-16C_50",								--aircraft type
			base = "Reserves",								--unit base
			tasks = {},
			number = 30,
		},
		[3] = {
			name = "No. 11 Squadron",								--unit name
			type = "F-16C bl.52d", 									--aircraft type
			country = "Pakistan",					--unit country
			livery = "",									--unit livery
			base = "Nellis AFB",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = true,
				["Intercept"] = true,
				["SEAD"] = true,
			},
			number = 8,
		},
		[4] = {
			name = "R-No.11",								--unit name
			inactive = true,								--unit is inactive
			type = "F-16C bl.52d",								--aircraft type
			base = "Reserves",								--unit base
			tasks = {},
			number = 30,
		},
		[5] = {
			name = "No. 9 Squadron",							--unit name
			player = false,									--player unit
			type = "F-86F Sabre",								--aircraft type
			country = "Pakistan",								--unit country
			livery = "",				--unit livery
			base = "Lincoln",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["Strike"] = true,					
			},
			number = 6,
		},
		[6] = {
			name = "R-No.9",								--unit name
			inactive = true,								--unit is inactive
			type = "F-86F Sabre",								--aircraft type
			base = "Reserves",								--unit base
			tasks = {},
			number = 30,
		},
		[7] = {
			name = "No. 25 Squadron",							--unit name
			player = false,									--player unit
			type = "MiG-19P",								--aircraft type
			country = "Pakistan",								--unit country
			livery = "",				--unit livery
			base = "Mesquite",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["Strike"] = true,					
			},
			number = 8,
		},
		[8] = {
			name = "R-No.25",								--unit name
			inactive = true,								--unit is inactive
			type = "MiG-19P",								--aircraft type
			base = "Reserves",								--unit base
			tasks = {},
			number = 30,
		},
		[9] = {
			name = "No. 28 Squadron",							--unit name
			player = false,									--player unit
			type = "UH-1H",								--aircraft type
			helicopter = true,								--true for helicopter units
			country = "USA",								--unit country
			livery = "US DOS",				--unit livery
			base = "FARP Sandy",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,					
			},
			number = 4,
		},
		[10] = {
			name = "R-UH-1H",								--unit name
			inactive = true,								--unit is inactive
			type = "UH-1H",								--aircraft type
			base = "Reserves",								--unit base
			tasks = {},
			number = 30,
		},
		[11] = {
			name = "No. 29 Squadron",							--unit name
			player = false,									--player unit
			type = "UH-1H",								--aircraft type
			helicopter = true,								--true for helicopter units
			country = "USA",								--unit country
			livery = "US DOS",				--unit livery
			base = "FARP Hilly",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,					
			},
			number = 4,
		},
		[12] = {
			name = "No. 27 Squadron",							--unit name
			player = false,									--player unit
			type = "SA342M",								--aircraft type
			helicopter = true,								--true for helicopter units
			country = "USA",								--unit country
			livery = "Sable",				--unit livery
			base = "FARP Lincoln",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,					
			},
			number = 4,
		},
		[13] = {
			name = "R-SA342M",								--unit name
			inactive = true,								--unit is inactive
			type = "SA342M",								--aircraft type
			base = "Reserves",								--unit base
			tasks = {},
			number = 30,
		},
		[14] = {
			name = "No. 10 Squadron",							--unit name
			player = false,									--player unit
			type = "F-86F Sabre",								--aircraft type
			country = "Pakistan",								--unit country
			livery = "",				--unit livery
			base = "Nellis AFB",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["Strike"] = true,					
			},
			number = 4,
		},
	},
	["red"] = {												--side 2
		[1] = {
			name = "177th Fighter Aviation Regiment",								--unit name
			player = false,									--player unit
			type = "Su-27",								--aircraft type
			country = "USSR",								--unit country
			livery = {""},					--unit livery
			base = "Tonopah AFB",							--unit base
			skill = "Random",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = true,
				["Intercept"] = true,
			},
			number = 6,
		},
		[2] = {
			name = "R/177th Fighter Aviation Regiment",								--unit name
			inactive = true,								--unit is inactive
			type = "Su-27",								--aircraft type
			base = "Reserves",								--unit base
			tasks = {},
			number = 16,
		},
		[3] = {
			name = "33rd Fighter Aviation Regiment",								--unit name
			player = false,									--player unit
			type = "MiG-29A",								--aircraft type
			country = "USSR",								--unit country
			livery = {""},					--unit livery
			base = "Tonopah AFB",							--unit base
			skill = "Random",									--unit skill
			tasks = {										--unit tasks
				["Escort"] = true,
				["CAP"] = true,
				["Intercept"] = true,
			},
			number = 10,
		},
		[4] = {
			name = "R/33rd Fighter Aviation Regiment",								--unit name
			inactive = true,								--unit is inactive
			type = "MiG-29A",								--aircraft type
			base = "Reserves",								--unit base
			tasks = {},
			number = 24,
		},
		[5] = {
			name = "187th Assault Aviation Regiment",								--unit name
			player = false,									--player unit
			type = "Su-25",								--aircraft type
			country = "USSR",								--unit country
			livery = {""},					--unit livery
			base = "Creech AFB",							--unit base
			skill = "Random",									--unit skill
			tasks = {										--unit tasks
				["SEAD"] = true,
				["Strike"] = true,
			},
			number = 6,
		},
		[6] = {
			name = "R/187th Assault Aviation Regiment",								--unit name
			inactive = true,								--unit is inactive
			type = "Su-25",								--aircraft type
			base = "Reserves",								--unit base
			tasks = {},
			number = 24,
		},
		[7] = {
			name = "458th Fighter Aviation Regiment",								--unit name
			player = false,									--player unit
			type = "MiG-21Bis",								--aircraft type
			country = "USSR",								--unit country
			livery = {""},					--unit livery
			base = "Groom Lake AFB",							--unit base
			skill = "Random",									--unit skill
			tasks = {										--unit tasks
				["Escort"] = true,
				["Strike"] = true,
				["Intercept"] = true,
			},
			number = 8,
		},
		[8] = {
			name = "R/458th Fighter Aviation Regiment",								--unit name
			inactive = true,								--unit is inactive
			type = "MiG-21Bis",								--aircraft type
			base = "Reserves",								--unit base
			tasks = {},
			number = 24,
		},
		[9] = {
			name = "202nd fixed-wing squadron",								--unit name
			player = false,									--player unit
			type = "MiG-15bis",								--aircraft type
			country = "USSR",								--unit country
			livery = {""},					--unit livery
			base = "Groom Lake AFB",							--unit base
			skill = "Random",									--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,
				["Intercept"] = true,
			},
			number = 8,
		},
		[10] = {
			name = "R/202nd fixed-wing squadron",								--unit name
			inactive = true,								--unit is inactive
			type = "MiG-15bis",								--aircraft type
			base = "Reserves",								--unit base
			tasks = {},
			number = 24,
		},
		[11] = {
			name = "559th Bomber Aviation Regiment",								--unit name
			player = false,									--player unit
			type = "Su-24M",								--aircraft type
			country = "USSR",								--unit country
			livery = {""},					--unit livery
			base = "Tonopah Airport",							--unit base
			skill = "Random",									--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,
			},
			number = 8,
		},
		[12] = {
			name = "R/559th Bomber Aviation Regiment",								--unit name
			inactive = true,								--unit is inactive
			type = "Su-24M",								--aircraft type
			base = "Reserves",								--unit base
			tasks = {},
			number = 16,
		},
		[13] = {
			name = "45th Independent Helicopter Regiment",								--unit name
			player = false,									--player unit
			type = "Mi-24V",								--aircraft type
			helicopter = true,								--true for helicopter units
			country = "USSR",								--unit country
			livery = {""},					--unit livery
			base = "Creech AFB",							--unit base
			skill = "Random",									--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,
			},
			number = 4,
		},
		[14] = {
			name = "R/45th Independent Helicopter Regiment",								--unit name
			inactive = true,								--unit is inactive
			type = "Mi-24V",								--aircraft type
			base = "Reserves",								--unit base
			tasks = {},
			number = 24,
		},
		[15] = {
			name = "361st Independent Helicopter Regiment",								--unit name
			player = false,									--player unit
			type = "Mi-8MT",								--aircraft type
			helicopter = true,								--true for helicopter units
			country = "USSR",								--unit country
			livery = "Russia_Army_Weather",					--unit livery
			base = "FARP Vetka",							--unit base
			skill = "Random",									--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,
			},
			number = 4,
		},
		[16] = {
			name = "R/361st Independent Helicopter Regiment",								--unit name
			inactive = true,								--unit is inactive
			type = "Mi-8MT",								--aircraft type
			base = "Reserves",								--unit base
			tasks = {},
			number = 24,
		},
		[17] = {
			name = "793rd Independent Helicopter Regiment",								--unit name
			player = true,									--player unit
			type = "Ka-50",								--aircraft type
			helicopter = true,								--true for helicopter units
			country = "USSR",								--unit country
			livery = {""},					--unit livery
			base = "FARP Skala",							--unit base
			skill = "Random",									--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,
			},
			number = 4,
		},
		[18] = {
			name = "R/793rd Independent Helicopter Regiment",								--unit name
			inactive = true,								--unit is inactive
			type = "Ka-50",								--aircraft type
			base = "Reserves",								--unit base
			tasks = {},
			number = 24,
		},
	}
}